#include <iostream>
#include <string.h>
using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl PRstring2.cpp

class String {
private:
    char *ptr;
public:
    String();
    String(char *s);
    String(const String &src);
    ~String();

    String& operator=(const String &src)
        {cpy(src.ptr); return *this;}

    String& operator=(char *s)
        {cpy(s); return *this;}

    String operator+(char *s);
    int operator==(const String &other);
    operator char*() {return ptr;}

    void cat(char *s);
    void cpy(char *s);
};

int main() {
    String a, b, c;
    a = "Ja ";
    b = "sam ";
    c = "toliko ";
    String d = a + b + c + "veseo!\n";
    cout << d;
    system("PAUSE");
    return 0;
}

// ----------------------------------
// FUNKCIJE KLASE STRING 

String::String() {
    ptr = new char[1];
    ptr[0] = '\0';
}

String::String(char *s) {
    int n = strlen(s);
    ptr = new char[n + 1];
    strcpy(ptr, s);
}

String::String(const String &src) {
    int n = strlen(src.ptr);
    ptr = new char[n + 1];
    strcpy(ptr, src.ptr);
}

String::~String() {
    delete [] ptr;
}

int String:: operator==(const String &other) {
    return (strcmp(ptr, other.ptr) == 0);
}

String String::operator+(char *s) {
    String new_str(ptr);
    new_str.cat(s);
    return new_str;
}

// cpy -- funkcija kopiranja stringa
//
void String::cpy(char *s) {
    delete [] ptr;
    int n = strlen(s);
    ptr = new char[n + 1];
    strcpy(ptr, s);
}

// cat -- funkcija ko=nkatenacije stringova
//
void String::cat(char *s) {

    // Alkociranje dovoljnog prostora za nove string podatke.

    int n = strlen(ptr) + strlen(s);
    char *p1 = new char[n + 1];

    // Kopiranje podataka u taj novi memorijski blok.

    strcpy(p1, ptr);
    strcat(p1, s);

    // Oslobadjanje starog memorijskog bloka i azururanje ptr.

    delete [] ptr;
    ptr = p1;
}
