#include <iostream>
using namespace std;

class  Razlomak {
private:
    int num, den;      // Brojilac i imenilac.
public:
    Razlomak() {set(0, 1);}
    Razlomak(int n, int d) {set(n, d);}
    Razlomak(int n) {set(n, 1);}
    Razlomak(const Razlomak &src) {set(src.num, src.den); }

    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num() const {return num;}
    int get_den() const {return den;}
    Razlomak add(const Razlomak &other);
    Razlomak mult(const Razlomak &other);
    Razlomak operator+(const Razlomak &other)
        {return add(other);}
    Razlomak operator*(const Razlomak &other)
        {return mult(other);}
    int operator==(const Razlomak &other);
    friend ostream &operator<<(ostream &os, Razlomak &fr);

protected:
    virtual void normalize();   // Konverzija u standardni oblik.
private:
    int gcf(int a, int b);     // Najveci zajednicki delilac.
    int lcm(int a, int b);     // Najmanji zajednicki sadrzlac.
};
