
#include <iostream>
using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl razlomak4.cpp

class Razlomak {
private:
    int num, den;      // Brojilac i imenilac.
public:
    Razlomak() {set(0, 1);}
    Razlomak(int n, int d) {set(n, d);}
    
    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num()  {return num;}
    int get_den()  {return den;}
    Razlomak add(Razlomak other);
    Razlomak mult(Razlomak other);
private:
    void normalize();   // Konvertovanje u standardan oblik.
    int gcf(int a, int b);     // Najveci zajednicki delilac.
    int lcm(int a, int b);     // Najmanji zajednicki sadrzalac.
};

int main() {
    Razlomak f1, f2;
    Razlomak f3(1, 2);

    cout << "Vrednost f1 je  ";
    cout << f1.get_num() << "/";
    cout << f1.get_den() << endl;

    cout << "vrednost f3 je ";
    cout << f3.get_num() << "/";
    cout << f3.get_den() << endl;
    system("PAUSE");
    return 0;
}

// ---------------------------------------------------
// FUNKCIJE KLASE RAZLOMAK

// Normalize: prevodi razlomak u standardan oblik,
//  jedinstven za svaku matematicki razlicitu vrednost.
//
void Razlomak::normalize(){

    // Slucajevi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // Postavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izdvajanje cinioca iz brojioca i imenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    return (a / gcf(a, b)) * b;
}

Razlomak Razlomak::add(Razlomak other) {
    Razlomak raz;
    int lcd = lcm(den, other.den);
    int quot1 = lcd/den;
    int quot2 = lcd/other.den;
    raz.set(num * quot1 + other.num * quot2, lcd);
    raz.normalize();
    return raz;
}

Razlomak Razlomak::mult(Razlomak other) {
    Razlomak raz;
    raz.set(num * other.num, den * other.den);
    raz.normalize();
    return raz;
}
