#include <iostream>
#include "Raz.h"
using namespace std;

// Normalize: prevodi Razlomak u standardan oblik,
//  jedinstven za svaku matematicki razlicitu vrednost.
//
void Razlomak::normalize(){

    // Slucajevi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // PPostavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izvajanje cinioca iz brojioca i imenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    int n = gcf(a, b);
    return a / n * b;
}

Razlomak Razlomak::add(const Razlomak &other) {
    int lcd = lcm(den, other.den);
    int quot1 = lcd/den;
    int quot2 = lcd/other.den;
    return Razlomak(num * quot1 + other.num * quot2, lcd);
    
}

Razlomak Razlomak::mult(const Razlomak &other) {
    return Razlomak(num * other.num, den * other.den);
}

int Razlomak::operator==(const Razlomak &other) {
    return (num == other.num && den == other.den);
}


// ---------------------------------------------------
//  FRIEND FUNCKCIJA KLASE Razlomak

ostream &operator<<(ostream &os, Razlomak &fr) {
    os << fr.num << "/" << fr.den;
    return os;
}

