#include <cstdlib>

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl razlomak1.cpp

class Razlomak {
private:
    int num, den;      // Brojilac i imenilac.
public:
    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num()  {return num;}
    int get_den()  {return den;}
private:
    void normalize();   // konvertovanje u standardni oblik.
    int gcf(int a, int b);   // Najveci zajednicki delilac.
    int lcm(int a, int b);   // Najmanji zajednicki sadrzaklac.
    };

// Normalize: prevodi razlomak u standardan oblok
//  jedinstven za svaku matematic=ki razlicitu vrednost.
//
void Razlomak::normalize(){

    // HProvera da li sadrze 0

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // postavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izdavanje cinioca iz brojioca i imeniooca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    return (a / gcf(a, b)) * b;
}
