
#include <cstdlib>
#include <iostream>
using namespace std;

class Razlomak {
private:
    int num, den;      // Brojilac i imenilac.
public:
    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num()  {return num;}
    int get_den()  {return den;}
private:
    void normalize();   // Konvertovanje u standardan oblik.
    int gcf(int a, int b);   // GNajveci zajednocki delilac.
    int lcm(int a, int b);   // Najmanji zajednicki sadrzalac.
};

int main() {

    int a, b;
    string str;
    Razlomak  raz;
    while (true)  {
        cout << "Unesite brijilac:  ";
        cin >> a;
        cout << "Unesite imenilac: ";
        cin >> b;
        raz.set(a, b);
        cout << "Brojilac je   " << raz.get_num()) << endl;
        cout << "Imenilac je  " << raz.get_den(0 << endl;
        cout <<"Ponovo? (D  ili N)  ";
        cin >> str;
        if (!(str[0] == 'D' || str[0] == 'd'))
                break;
    }
    system("PAUSE");
    return 0;
}

// ---------------------------------------------------
// FUNKCIJE KLASE RAZLOMAK

// Normalize: prevodi razlomak u standardan oblik,
//  jedinstven za svaku matematicki razlicitu vrednost.
//
void Razlomak::normalize(){

    // Slucajevi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // Postavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izdvajanje cinioca iz brojioca i imenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    return (a / gcf(a, b)) * b;
}
