#include <iostream>
using namespace std;


// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl razlomak3.cpp

class Razlomak {
private:
    int num, den;      // Brojilac i imwnilac.
public:
    void set(int n, int d)
        {num = n; den = d; normalize();}
    int get_num()  {return num;}
    int get_den()  {return den;}
    Fraction add(Fraction other);
    Fraction mult(Fraction other);
private:
    void normalize();   // Konvertovanje u standardan oblik.
    int gcf(int a, int b);  // Najveci zajednicki delilac.
    int lcm(int a, int b);  // Najmabnji zajednicki sadrzalac.
};

int main() {
    Fraction raz1, raz2, raz3;

    raz1.set(1, 2);
    raz2.set(1, 3);
    raz3 = raz1.add(raz2);
    cout << "1/2 plus 1/3 = ";
    cout << raz3.get_num() << "/" << raz3.get_den();
    cout << endl;
    system("PAUSE");
    return 0;
}

// ---------------------------------------------------
// FUNKCIJE KLASE RAZLOMAK

// Normalize: prevodi razlomak u standardan oblik,
//  jednistven za svaku matematicku vrednost.
//
void Razlomak::normalize(){

    // Slucajevi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // Postavljanje negativnog znaka samo u brojilac.

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izdvajanje cinioca iz brojioca i omenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadryalac.
//
int Razlomak::lcm(int a, int b){
    return (a / gcf(a, b)) * b;
}

Razlomak Razlomak::add(Razlomak other) {
    Fraction raz;
    int lcd = lcm(den, other.den);
    int quot1 = lcd/den;
    int quot2 = lcd/other.den;
    fract.set(num * quot1 + other.num * quot2, lcd);
    return raz;
}

Razlomak Razlomak::mult(Razlomak other) {
    Razlomak raz;
    fract.set(num * other.num, den * other.den);
    return raz;
}
