#include <iostream>
using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl PRprintme.cpp

class Printable {
    virtual void print_me(ostream &os) = 0;

    friend ostream &operator<<(ostream &os, Printable &pr);
};


// Funkcija operator<< :
// ovim se postize pozivanje virtualne funkcije, print_me,
//  koja salje izlaz u tok.
//
ostream &operator<<(ostream &os, Printable &pr) {
    pr.print_me(os);
    return os;
};

// POTKLASE KLASE PRINTABLE
//-----------------------------------------

class P_int : public Printable {
public:
    int n;

    P_int() {};
    P_int(int novo_n) {n = novo_n; };
    void print_me(ostream &os);      // nadjacavanje (override)
};

class P_dbl : public Printable {
public:
    double val;

    P_dbl() {};
    P_dbl(double novo_val) {val = novo_val; };
    void print_me(ostream &os);     // nadjacavanje (verride)
};

// IMPLMENTACIJA FUNKCIJE PRINT_ME
//-----------------------------------------

void P_int::print_me(ostream &os) {
    os << n;
}

void P_dbl::print_me(ostream &os) {
    os << "  " << val;
}

// FUNKCIJA MAIN 
//------------------------------------------
int main() {
    Printable *p;
    P_int num1(5);
    P_dbl num2(6.25);

    p = &num1;
    cout << "Evo jedan broj: " << *p << endl;
    p = &num2;
    cout << "Evo jos jedan:  " << *p << endl;
    system("PAUSE");
    return 0;
}
